# this script combines columns of each CSV file and normalize the value over the total column intensity. 
# Written by Xueer Jiang, Jao lab, University of California, Davis (April 2019). Publications that have 
# utilized this script should acknowledge the resource and cite our Bio-Protocol Paper.






# Set directory
setwd('/Users/jaolab')
Designated.location = '~/Desktop/test_data'
All.files = paste0(Designated.location, '/', list.files(Designated.location))

# Combine multiple files horizontally (column by column)
xoutput = do.call(cbind, lapply(All.files, function(path){
  read.csv(path, header = TRUE)
}))

# Output of combined data
write.csv(xoutput, paste0(Designated.location, '/original_dataset.csv'), row.names = FALSE)

# Normalize combined original data (getting fraction of each cell divided by its column total)
df = read.csv(paste0(Designated.location, '/original_dataset.csv'), header = TRUE)
column_sum= colSums(df)
new.df = matrix(numeric(), nrow = nrow(df), ncol = ncol(df))
for (i in 1:length(column_sum)) ({
  new.df[, i] = as.matrix(df[, i] / column_sum[i])
})
new.df = data.frame(new.df)
names(new.df) = rep(c('first_centrosome', 'second_centrosome'),  (ncol(new.df)/2))
# Output normalized data
write.csv(new.df, paste0(Designated.location, "/normalized_dataset.csv"), row.names = FALSE)

 

